/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.idgen;

import com.jeesite.common.codec.EncodeUtils;
import com.jeesite.common.idgen.IdWorker;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import java.security.SecureRandom;
import java.util.UUID;

public class IdGenerate {
    private static SecureRandom random = new SecureRandom();
    private static IdWorker idWorker = new IdWorker(-1L, -1L);

    public static String uuid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static long randomLong() {
        return Math.abs(random.nextLong());
    }

    public static String randomBase62(int length) {
        byte[] randomBytes = new byte[length];
        random.nextBytes(randomBytes);
        return EncodeUtils.encodeBase62(randomBytes);
    }

    public static String nextId() {
        return String.valueOf(idWorker.nextId());
    }

    public static String nextCode(String code) {
        if (code != null) {
            String str = code.trim();
            int len = str.length() - 1;
            int lastNotNumIndex = 0;
            for (int i = len; i >= 0; --i) {
                if (str.charAt(i) >= '0' && str.charAt(i) <= '9') continue;
                lastNotNumIndex = i;
                break;
            }
            if (str.charAt(len) >= '0' && str.charAt(len) <= '9' && lastNotNumIndex == len) {
                lastNotNumIndex = -1;
            }
            String prefix = str.substring(0, lastNotNumIndex + 1);
            String numStr = str.substring(lastNotNumIndex + 1, str.length());
            long num = ObjectUtils.toLong(numStr);
            str = prefix + StringUtils.leftPad((String)String.valueOf(num + 1L), (int)numStr.length(), (String)"0");
            return str;
        }
        return null;
    }
}

