/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aop;

import org.springframework.integration.aop.AbstractMessageSourceAdvice;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.util.DynamicPeriodicTrigger;
import org.springframework.messaging.Message;

public class SimpleActiveIdleMessageSourceAdvice
extends AbstractMessageSourceAdvice {
    private final DynamicPeriodicTrigger trigger;
    private volatile long idlePollPeriod;
    private volatile long activePollPeriod;

    public SimpleActiveIdleMessageSourceAdvice(DynamicPeriodicTrigger trigger) {
        this.trigger = trigger;
        this.idlePollPeriod = trigger.getPeriod();
        this.activePollPeriod = trigger.getPeriod();
    }

    public void setIdlePollPeriod(long idlePollPeriod) {
        this.idlePollPeriod = idlePollPeriod;
    }

    public void setActivePollPeriod(long activePollPeriod) {
        this.activePollPeriod = activePollPeriod;
    }

    @Override
    public Message<?> afterReceive(Message<?> result, MessageSource<?> source) {
        if (result == null) {
            this.trigger.setPeriod(this.idlePollPeriod);
        } else {
            this.trigger.setPeriod(this.activePollPeriod);
        }
        return result;
    }
}

