/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support;

import org.springframework.integration.support.AcknowledgmentCallback;
import org.springframework.integration.support.StaticMessageHeaderAccessor;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;

public final class AckUtils {
    private AckUtils() {
    }

    @Nullable
    public static AcknowledgmentCallback getAckCallback(Message<?> message) {
        return StaticMessageHeaderAccessor.getAcknowledgmentCallback(message);
    }

    public static void autoAck(AcknowledgmentCallback ackCallback) {
        if (ackCallback != null && ackCallback.isAutoAck() && !ackCallback.isAcknowledged()) {
            ackCallback.acknowledge(AcknowledgmentCallback.Status.ACCEPT);
        }
    }

    public static void autoNack(AcknowledgmentCallback ackCallback) {
        if (ackCallback != null && ackCallback.isAutoAck() && !ackCallback.isAcknowledged()) {
            ackCallback.acknowledge(AcknowledgmentCallback.Status.REJECT);
        }
    }

    public static void accept(@Nullable AcknowledgmentCallback ackCallback) {
        if (ackCallback != null) {
            ackCallback.acknowledge(AcknowledgmentCallback.Status.ACCEPT);
        }
    }

    public static void reject(@Nullable AcknowledgmentCallback ackCallback) {
        if (ackCallback != null) {
            ackCallback.acknowledge(AcknowledgmentCallback.Status.REJECT);
        }
    }

    public static void requeue(@Nullable AcknowledgmentCallback ackCallback) {
        if (ackCallback != null) {
            ackCallback.acknowledge(AcknowledgmentCallback.Status.REQUEUE);
        }
    }
}

