/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support.converter;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamClass;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.core.ConfigurableObjectInputStream;
import org.springframework.core.NestedIOException;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.serializer.DefaultDeserializer;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.support.SerializationFailedException;
import org.springframework.util.Assert;
import org.springframework.util.PatternMatchUtils;

public class WhiteListDeserializingConverter
implements Converter<byte[], Object> {
    private final Deserializer<Object> deserializer;
    private final ClassLoader defaultDeserializerClassLoader;
    private final boolean usingDefaultDeserializer;
    private final Set<String> whiteListPatterns = new LinkedHashSet<String>();

    public WhiteListDeserializingConverter() {
        this((Deserializer<Object>)new DefaultDeserializer());
    }

    public WhiteListDeserializingConverter(ClassLoader classLoader) {
        this((Deserializer<Object>)new DefaultDeserializer(classLoader));
    }

    public WhiteListDeserializingConverter(Deserializer<Object> deserializer) {
        Assert.notNull(deserializer, (String)"Deserializer must not be null");
        this.deserializer = deserializer;
        if (deserializer instanceof DefaultDeserializer) {
            ClassLoader classLoader = null;
            try {
                classLoader = (ClassLoader)new DirectFieldAccessor(deserializer).getPropertyValue("classLoader");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.defaultDeserializerClassLoader = classLoader;
            this.usingDefaultDeserializer = true;
        } else {
            this.defaultDeserializerClassLoader = null;
            this.usingDefaultDeserializer = false;
        }
    }

    public void setWhiteListPatterns(String ... whiteListPatterns) {
        this.whiteListPatterns.clear();
        Collections.addAll(this.whiteListPatterns, whiteListPatterns);
    }

    public void addWhiteListPatterns(String ... patterns) {
        Collections.addAll(this.whiteListPatterns, patterns);
    }

    public Object convert(byte[] source) {
        ByteArrayInputStream byteStream = new ByteArrayInputStream(source);
        try {
            if (this.usingDefaultDeserializer) {
                return this.deserialize(byteStream);
            }
            return this.deserializer.deserialize((InputStream)byteStream);
        }
        catch (Throwable ex) {
            throw new SerializationFailedException("Failed to deserialize payload. Is the byte array a result of corresponding serialization for " + this.deserializer.getClass().getSimpleName() + "?", ex);
        }
    }

    protected Object deserialize(ByteArrayInputStream inputStream) throws IOException {
        try {
            ConfigurableObjectInputStream objectInputStream = new ConfigurableObjectInputStream(inputStream, this.defaultDeserializerClassLoader){

                protected Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
                    Class clazz = super.resolveClass(classDesc);
                    WhiteListDeserializingConverter.this.checkWhiteList(clazz);
                    return clazz;
                }
            };
            return objectInputStream.readObject();
        }
        catch (ClassNotFoundException ex) {
            throw new NestedIOException("Failed to deserialize object type", (Throwable)ex);
        }
    }

    protected void checkWhiteList(Class<?> clazz) throws IOException {
        if (this.whiteListPatterns.isEmpty()) {
            return;
        }
        if (clazz.isArray() || clazz.isPrimitive() || clazz.equals(String.class) || Number.class.isAssignableFrom(clazz)) {
            return;
        }
        String className = clazz.getName();
        for (String pattern : this.whiteListPatterns) {
            if (!PatternMatchUtils.simpleMatch((String)pattern, (String)className)) continue;
            return;
        }
        throw new SecurityException("Attempt to deserialize unauthorized " + clazz);
    }
}

