/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support.utils;

import java.io.UnsupportedEncodingException;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;

public final class IntegrationUtils {
    private static final Log logger = LogFactory.getLog(IntegrationUtils.class);
    public static final String INTEGRATION_CONVERSION_SERVICE_BEAN_NAME = "integrationConversionService";
    public static final String INTEGRATION_MESSAGE_BUILDER_FACTORY_BEAN_NAME = "messageBuilderFactory";
    public static final boolean fatalWhenNoBeanFactory = Boolean.valueOf(System.getenv("SI_FATAL_WHEN_NO_BEANFACTORY"));

    private IntegrationUtils() {
    }

    public static ConversionService getConversionService(BeanFactory beanFactory) {
        return IntegrationUtils.getBeanOfType(beanFactory, INTEGRATION_CONVERSION_SERVICE_BEAN_NAME, ConversionService.class);
    }

    public static MessageBuilderFactory getMessageBuilderFactory(BeanFactory beanFactory) {
        MessageBuilderFactory messageBuilderFactory = null;
        if (beanFactory != null) {
            try {
                messageBuilderFactory = (MessageBuilderFactory)beanFactory.getBean(INTEGRATION_MESSAGE_BUILDER_FACTORY_BEAN_NAME, MessageBuilderFactory.class);
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("No MessageBuilderFactory with name 'messageBuilderFactory' found: " + e.getMessage() + ", using default."));
                }
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No 'beanFactory' supplied; cannot find MessageBuilderFactory, using default.");
            }
            if (fatalWhenNoBeanFactory) {
                throw new RuntimeException("All Message creators need a BeanFactory");
            }
        }
        if (messageBuilderFactory == null) {
            messageBuilderFactory = new DefaultMessageBuilderFactory();
        }
        return messageBuilderFactory;
    }

    private static <T> T getBeanOfType(BeanFactory beanFactory, String beanName, Class<T> type) {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        if (!beanFactory.containsBean(beanName)) {
            return null;
        }
        return (T)beanFactory.getBean(beanName, type);
    }

    public static byte[] stringToBytes(String value, String encoding) {
        try {
            return value != null ? value.getBytes(encoding) : null;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String bytesToString(byte[] bytes, String encoding) {
        try {
            return bytes == null ? null : new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static RuntimeException wrapInDeliveryExceptionIfNecessary(Message<?> message, Supplier<String> text, Exception e) {
        RuntimeException runtimeException;
        RuntimeException runtimeException2 = runtimeException = e instanceof RuntimeException ? (RuntimeException)e : new MessageDeliveryException(message, text.get(), (Throwable)e);
        if (!(e instanceof MessagingException) || ((MessagingException)e).getFailedMessage() == null) {
            runtimeException = new MessageDeliveryException(message, text.get(), (Throwable)e);
        }
        return runtimeException;
    }

    public static RuntimeException wrapInHandlingExceptionIfNecessary(Message<?> message, Supplier<String> text, Exception e) {
        RuntimeException runtimeException;
        RuntimeException runtimeException2 = runtimeException = e instanceof RuntimeException ? (RuntimeException)e : new MessageHandlingException(message, text.get(), (Throwable)e);
        if (!(e instanceof MessagingException) || ((MessagingException)e).getFailedMessage() == null) {
            runtimeException = new MessageHandlingException(message, text.get(), (Throwable)e);
        }
        return runtimeException;
    }
}

