/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.script;

import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface RedisScript<T> {
    public String getSha1();

    @Nullable
    public Class<T> getResultType();

    public String getScriptAsString();

    default public boolean returnsRawValue() {
        return this.getResultType() == null;
    }

    public static <T> RedisScript<T> of(String script) {
        return new DefaultRedisScript(script);
    }

    public static <T> RedisScript of(String script, Class<T> resultType) {
        Assert.notNull((Object)script, (String)"Script must not be null!");
        Assert.notNull(resultType, (String)"ResultType must not be null!");
        return new DefaultRedisScript<T>(script, resultType);
    }
}

