function exsitPhone(value) {
    var result = true;
    $.ajax("/api/user/getByPhone", {
        method: "post", dataType: "json", data: {"phone": value}, async:false,
        success: function (data) {
            if (Number(data.data)==0) {
                result = false;
            }
        }
    });
    return result;

}

function checkMmsCode(phone, code){
    var result = true;
    var str = $("#vCode").val();
    if ($("#mobile").valid() && str.length == 6) {
        $.ajax("/api/validateCodeMms?phone="+phone+"&code="+code+"&type=0", {
            method: "get", dataType: "json", data: {}, async:false,
            success: function (data) {
                if (!(0==Number(data.status))) {
                    result = false;
                    $("#vCode").prev().removeClass("fa-check");
                } else {
                    $("#vCode").prev().addClass("fa-check");
                }
            }
        });
    }
    return result;
}

if ($.validator) {
    $.validator.addMethod("isValidCode",function(value, element){
        var phone = $("#mobile").val();
        return checkMmsCode(phone, value);
    },"验证码验证失败，请尝试重新获取验证码");


    $.validator.addMethod("isExistPhone",function(value, element){
        return exsitPhone(value);
    },"不存在此手机号对应的账户，请查验或先注册");

    $.validator.addMethod("isExistPhoneAccount",function(value, element){
        return !exsitPhone(value);
    },"系统中已存在此手机号对应的账户，请查验");

    $.validator.addMethod("codeIntegerRule",function(value, element){
        $("#vCode").prev().removeClass("fa-check")
        var intValue = parseInt(value);
        var repgValue = parseInt(value.replace(/\b(0+)/gi,""));
        return intValue > 0 && ((intValue+"") == value || repgValue == intValue);
    },"验证码必须为正整数");

}

function btnVal(sec){
    if(!sec||isNaN(parseInt(sec)))
        return;
    var args = arguments;
    var self = this;

    $("#btnSendMms").html(sec);

    const timer = setTimeout(function (){
        args.callee.call(self, --sec);
        if (sec<=0) {
            clearTimeout(timer);
            $("#btnSendMms").html("重发");
            $("#btnSendMms").removeClass("btn-default").addClass("btn-primary");
        }
    },1000)
}

function getMmsCode(phone){
    $.ajax("/api/sendCodeMms?phone="+phone+"&type=0", {
        method: "get", dataType: "json", data: {},
        success: function (data) {
            if (0==data.status) {
                layer.msg("验证码发送成功", {icon: 6, time: 2000});
            } else {
                layer.msg('<p class="text-red">'+data.errMsg+'</p>', {icon: 5, time: 2000})
            }
        }
    });
}

$(document).on("click", "#btnSendMms", function(){

    var obj = $("#btnSendMms");
    // $("#mobile").valid();
    if ($("#mobile").valid()) {
        $("#vCode").attr("value", "");
        if (obj.hasClass("btn-primary")) {
            getMmsCode($("#mobile").val());
            obj.removeClass("btn-primary").addClass("btn-default");
            btnVal(60);
        }
    }


})

$("#vCode").bind('input propertychange', function() {
    if ($("#mobile").valid()) {
        $("#vCode").valid();
    }
    // obj.addClass("fa-check");
})
