/*
 * Decompiled with CFR 0.152.
 */
package com.tenginekit.body;

import com.tenginekit.KitCore;
import com.tenginekit.body.BodyDetectInfo;
import com.tenginekit.body.BodyLandmarkInfo;
import com.tenginekit.jni.FaceSchedule;
import com.tenginekit.model.TenginekitPoint;
import java.util.ArrayList;
import java.util.List;

public class Body {
    public static synchronized BodyDetect detect(byte[] imageData) {
        float[] bodys = FaceSchedule.bodyDetect((byte[])imageData);
        return new BodyDetect(bodys);
    }

    public static class BodyDetect {
        private static BodyDetect Last;
        private int bodyCount = 0;
        private List<BodyDetectInfo> detectInfos;

        private BodyDetect(float[] body) {
            if (body == null) {
                this.bodyCount = 0;
                this.detectInfos = null;
                return;
            }
            this.bodyCount = body.length / 4;
            this.detectInfos = new ArrayList<BodyDetectInfo>(this.bodyCount);
            for (int i = 0; i < body.length; i += 4) {
                BodyDetectInfo bodyInfo = new BodyDetectInfo();
                bodyInfo.left = (int)body[i];
                bodyInfo.top = (int)body[i + 1];
                bodyInfo.right = (int)body[i + 2];
                bodyInfo.bottom = (int)body[i + 3];
                bodyInfo.width = bodyInfo.right - bodyInfo.left;
                bodyInfo.height = bodyInfo.bottom - bodyInfo.top;
                this.detectInfos.add(bodyInfo);
            }
            Last = this;
        }

        public synchronized boolean isVaild() {
            return this == Last;
        }

        public synchronized int getBodyCount() {
            return this.bodyCount;
        }

        public synchronized List<BodyDetectInfo> getDetectInfos() {
            return this.detectInfos;
        }

        public synchronized List<BodyLandmarkInfo> landmark2d() {
            if (!KitCore.getInit()) {
                throw new RuntimeException("SDK not init");
            }
            if (!this.isVaild()) {
                throw new RuntimeException("Current obj is invaild");
            }
            if (this.bodyCount == 0) {
                return null;
            }
            ArrayList<BodyLandmarkInfo> bodyLandmarkInfos = new ArrayList<BodyLandmarkInfo>(this.bodyCount);
            float[] landmarks = FaceSchedule.getBodyLandmark();
            int DataCount = landmarks.length / this.bodyCount;
            int landmarkCount = DataCount / 2;
            for (int i = 0; i < this.bodyCount; ++i) {
                BodyLandmarkInfo cur_Body = new BodyLandmarkInfo();
                cur_Body.landmarks = new ArrayList<TenginekitPoint>();
                for (int j = 0; j < landmarkCount; ++j) {
                    TenginekitPoint l = new TenginekitPoint(landmarks[j * 2 + DataCount * i], landmarks[j * 2 + 1 + DataCount * i]);
                    cur_Body.landmarks.add(l);
                }
                bodyLandmarkInfos.add(cur_Body);
            }
            return bodyLandmarkInfos;
        }
    }
}

