/*
 * Decompiled with CFR 0.152.
 */
package com.tenginekit;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.text.TextUtils;
import com.tenginekit.AndroidConfig;
import com.tenginekit.jni.FaceSchedule;
import com.tenginekit.utils.DeviceUtil;

public class KitCore {
    private static Context mContext;
    private static String UUID;
    private static String PACKAGENAME;
    private static boolean inited;

    private static void setContext(Context context) {
        mContext = context;
    }

    private static Context getContext() {
        return mContext;
    }

    private static void setUUID(String uuid) {
        UUID = uuid;
    }

    private static String getUUID() {
        return UUID;
    }

    private static void setPackageName(String name) {
        PACKAGENAME = name;
    }

    private static String getPackageName() {
        return PACKAGENAME;
    }

    private static void setInit(boolean is) {
        inited = is;
    }

    public static boolean getInit() {
        return inited;
    }

    public static synchronized void init(Context context, AndroidConfig config) {
        if (KitCore.getInit()) {
            return;
        }
        if (context == null) {
            throw new RuntimeException("Context is NULL");
        }
        KitCore.setContext(context);
        KitCore.getID();
        if (config.openFuncList != null) {
            for (int i = 0; i < config.openFuncList.size(); ++i) {
                String funcName = config.openFuncList.get(i).toString();
                FaceSchedule.setFunc(funcName);
            }
        }
        FaceSchedule.init(context.getAssets(), config.inputImageW, config.inputImageH, config.outputImageW, config.outputImageH, config.imageFormat.toString(), String.valueOf((Object)config.handleMode), KitCore.getPackageName(), KitCore.getUUID());
        KitCore.setInit(true);
    }

    public static synchronized void release() {
        if (!KitCore.getInit()) {
            return;
        }
        FaceSchedule.release();
        KitCore.setInit(false);
    }

    private static void getID() {
        try {
            String readDeviceID = DeviceUtil.readDeviceID(KitCore.getContext());
            SharedPreferences mShare = KitCore.getContext().getSharedPreferences("uuid", 0);
            String string = mShare.getString("uuid", "");
            if (string != null && readDeviceID == null && !TextUtils.equals((CharSequence)string, (CharSequence)readDeviceID) && TextUtils.isEmpty((CharSequence)readDeviceID) && !TextUtils.isEmpty((CharSequence)string)) {
                readDeviceID = string;
                DeviceUtil.saveDeviceID(readDeviceID, KitCore.getContext());
            }
            if (readDeviceID == null) {
                readDeviceID = DeviceUtil.getDeviceId(KitCore.getContext());
            }
            mShare.edit().putString("uuid", readDeviceID).apply();
            PackageManager packageManager = KitCore.getContext().getPackageManager();
            int flag = 8192;
            if (Build.VERSION.SDK_INT >= 24) {
                flag = 8192;
            }
            String _packageName = "";
            try {
                PackageManager packageManager1 = KitCore.getContext().getPackageManager();
                PackageInfo packageInfo = packageManager1.getPackageInfo(KitCore.getContext().getPackageName(), 0);
                _packageName = packageInfo.packageName;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            KitCore.setUUID(readDeviceID);
            KitCore.setPackageName(_packageName);
        }
        catch (Exception e) {
            KitCore.setUUID("unknow");
            KitCore.setPackageName("unknow");
            e.printStackTrace();
        }
    }

    static {
        UUID = "unknow";
        PACKAGENAME = "unknow";
        inited = false;
    }

    public static class Camera {
        public static synchronized void setRotation(int ori, boolean isScreenRotate, int outputW, int outputH) {
            if (!KitCore.getInit()) {
                return;
            }
            FaceSchedule.setOri(ori, isScreenRotate, outputW, outputH);
        }

        public static synchronized void switchCamera(boolean back) {
            if (!KitCore.getInit()) {
                return;
            }
            if (back) {
                FaceSchedule.switchCamera(1);
            } else {
                FaceSchedule.switchCamera(0);
            }
        }
    }
}

